#include "model.ih"

void Model::addCands(string const *cands, double const *vals, size_t const numCands)
{
    for (size_t candIdx = 0; candIdx != numCands; ++candIdx)
    {
        string curCand(cands[candIdx]);
        double curVal(vals[candIdx]);
        auto got = d_curCands.find(curCand);
        if (got == d_curCands.end())
        {
            size_t candId = d_cands[d_wordIdx].size();
            d_cands[d_wordIdx].push_back(curCand);
            d_curCands.emplace(curCand, candId);
            d_featVals[d_wordIdx].resize((candId +1) * d_config->numFeats);
            d_featVals[d_wordIdx][candId * d_config->numFeats + d_featIdx] = curVal;
        }
        else
        {
            size_t candId = got->second;
            d_featVals[d_wordIdx][candId * d_config->numFeats + d_featIdx] = curVal; 
        }
    }
}
