#include "model.ih"

void Model::train(const string &path, ostream *out)
{
    ifstream in(path);
    if (!in.good())
    {
        cerr << "Could not read training file: " << path << '\n';
        exit(1);
    }
    genLookup(&in, d_config->numTrain);

    in.close();
    in.open(path);
    size_t sentIdx = 0;
    ofstream featFile(d_config->featsPath);
    if (!featFile.good())
    {
        cerr << "Could not write features: " << d_config->featsPath << '\n';
        exit(1);
    }
    featFile << d_config->header;
    for(; sentIdx != d_config->numTrain; ++sentIdx)
    {
        if(!readGold(&in))
        {
            cerr << "not enough sentences\n";
            break;
        }
        d_cands.clear();
        d_featVals.clear();
        for (d_wordIdx = 0; d_wordIdx < d_origs.size(); ++d_wordIdx)
        {
            gen();
            addGold();
            writeFeats(&featFile);
        }
    }
    cerr << "Trained on " << sentIdx << " sentences\n";
    featFile.close();

    Forest* forest = 0;
    vector<string> emptyVec;
    forest = new ForestProbability;//ForestClassification;
    forest->initCpp("gold", MEM_DOUBLE, d_config->featsPath, // depvar, memMode, inputFile
                0, d_config->cleanedPath, 500, //mtry, outprefix, numTrees
                &cerr, d_config->seed, d_config->numThreads, // verboseOut, seed, nthreads
                "", DEFAULT_IMPORTANCE_MODE, // forestPath, importance measure
                0, "", emptyVec, // targetpartitionsize?, splitweightsfile, alwayssplitvars
                "", true, emptyVec, // statusvarname,replace, catvars
                false, DEFAULT_SPLITRULE, "", //savemem, splitrule, caseweights
                false, 1, DEFAULT_ALPHA, DEFAULT_MINPROP, //predall, fraction, minProb
                false, DEFAULT_PREDICTIONTYPE); // holdout, predictiontype

    forest->run(true);
    forest->saveToFile();
    forest->writeOutput();
    delete forest;
    
    test(&in, out);
}

