// Example 102 from page 89 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.io.*;
import java.text.DecimalFormat;

class Example102 {
  public static void main(String[] args) throws IOException {
    System.out.println("Printing temperature table to file temperature.html");
    PrintWriter pw = new PrintWriter(new FileWriter("temperature.html"));
    DecimalFormat ff = new DecimalFormat("#0"), cf = new DecimalFormat("0.0");
    pw.println("<TABLE BORDER><TR><TH>Fahrenheit<TH>Celsius</TR>");
    for (double f=100; f<=400; f+=10) {
      double c = 5 * (f - 32) / 9;
      pw.println("<TR ALIGN=RIGHT><TD>" + ff.format(f) + "<TD>" + cf.format(c));
    }
    pw.println("</TABLE>");
    pw.close();                 // without this, the output file may be empty
  }
}

