// Example 103 from page 89 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.io.*;
import java.text.DecimalFormat;

class Example103 {
  public static void main(String[] args) throws IOException {
    System.out.println("Printing temperature table to file temperature.txt");
    PrintWriter pw = new PrintWriter(new FileWriter("temperature.txt"));
    DecimalFormat ff = new DecimalFormat("#0"), cf = new DecimalFormat("0.0");
    pw.println("Fahrenheit   Celsius");
    for (double f=100; f<=400; f+=10) {
      double c = 5 * (f - 32) / 9;
      pw.println(padLeft(ff.format(f), 10) + padLeft(cf.format(c), 10));
    }
    pw.close();
  }

  static String padLeft(String s, int width) {
    StringBuffer res = new StringBuffer();
    for (int i=width-s.length(); i>0; i--)
      res.append(' ');
    return res.append(s).toString();
  }
}

