// Example 104 from page 91 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.io.*;

class Example104 {
  public static void main(String[] args) throws IOException {
    if (args.length != 1) 
      System.out.println("Usage: java Example104 <filename>");
    else
      sumfile(args[0]);
  }

  static void sumfile(String filename) throws IOException {
    Reader r = new BufferedReader(new FileReader(filename));
    StreamTokenizer stok = new StreamTokenizer(r);
    double sum = 0;                                       
    stok.nextToken();                                  
    while (stok.ttype != StreamTokenizer.TT_EOF) {
      if (stok.ttype == StreamTokenizer.TT_NUMBER)
        sum += stok.nval;
      else
        System.out.println("Non-number: " + stok.sval);
      stok.nextToken();                              
    }
    System.out.println("The file sum is " + sum);
  }                                     
}

