// Example 110 from page 101 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.io.*;
import java.util.*;

class Example110 {
  public static void main(String[] args) throws IOException {
    final int count = 40000;
    System.out.println("Writing " + count + " strings to random access string array file");
    Iterator strIter = 
      new Iterator() {
          int i = 0;
          public boolean hasNext() { return i < count; }

          public Object next() { return "string" + i++; }

          public void remove() { }
        };
    writeStrings("saf.dat", strIter);
  }

  static void writeStrings(String filename, Iterator strIter) 
    throws IOException {
    RandomAccessFile raf = new RandomAccessFile(filename, "rw");
    raf.setLength(0);                                   // truncate the file
    ArrayList offsettable = new ArrayList();            // contains Longs
    while (strIter.hasNext()) {
      offsettable.add(new Long(raf.getFilePointer()));  // store string offset
      raf.writeUTF((String)strIter.next());             // write string
    }
    Iterator iter = offsettable.iterator(); 
    while (iter.hasNext())                              // write string offsets
      raf.writeLong(((Long)iter.next()).longValue());
    raf.writeInt(offsettable.size());                   // write string count
    raf.close();
  }
}

