// Example 112 from page 103 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.io.*;

class Example112 {
  public static void main(String[] args) throws IOException {
    if (args.length > 0)
      showDir(0, new File(args[0]));
    else
      showDir(0, new File(".."));
  }

  static void showDir(int indent, File file) throws IOException {
    for (int i=0; i<indent; i++)
      System.out.print('-');
    System.out.println(file.getName());
    if (file.isDirectory()) {
      File[] files = file.listFiles();
      for (int i=0; i<files.length; i++)
        showDir(indent+4, files[i]);
    } 
  }
}

