// Example 67 from page 49 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.io.*;

class Example67 {
  public static void main(String[] args) throws IOException { 
    double[] xs = readRecord("foo");
    for (int i=0; i<xs.length; i++)
      System.out.println(xs[i]);
  }

  static double[] readRecord(String filename) throws IOException {
    Reader freader         = new FileReader(filename); 
    BufferedReader breader = new BufferedReader(freader);
    double[] res = new double[3];
    try {
      res[0] = new Double(breader.readLine()).doubleValue();
      res[1] = new Double(breader.readLine()).doubleValue();
      res[2] = new Double(breader.readLine()).doubleValue();
    } finally {
      breader.close();
    }
    return res;
  }
}

