// Example 72 from page 53 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.awt.*;

class Example72 {
  static void printcolors(Colored[] cs) {
    for (int i=0; i<cs.length; i++)
      System.out.println(cs[i].getColor().toString());
  } 

  static void draw(Graphics g, ColoredDrawable[] cs) {
    for (int i=0; i<cs.length; i++) { 
      g.setColor(cs[i].getColor()); 
      cs[i].draw(g);
    }
  } 

  public static void main(String[] args) {
    final ColoredDrawable[] cs = 
          { new ColoredDrawablePoint(3, 4, Color.red), 
            new ColoredRectangle(50, 100, 60, 110, Color.green) };
    printcolors(cs);
    Frame f = new Frame();
    // Anonymous local inner class, subclass of java.awt.Canvas
    f.add(new Canvas() {
      public void paint(Graphics g) {
        draw(g, cs);
      }
      public Dimension getPreferredSize() { return new Dimension(400, 300); }
      });
    f.pack(); f.show();
  }    
}

