// Example 78 from page 61 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)


class Buffer {
  private int contents;
  private boolean empty = true;
  public int get() {
    synchronized (this) {
      while (empty)
        try { this.wait(); } catch (InterruptedException x) {};
      empty = true;
      this.notify();
      return contents;
  } }
  public void put(int v) {
    synchronized (this) {
      while (!empty)
        try { this.wait(); } catch (InterruptedException x) {};
      empty = false; 
      contents = v; 
      this.notify();
  } }
}

class Example78 {
  public static void main(String[] args) {
    final Buffer buf = new Buffer();

    class Producer extends Thread {
      public void run() {
        for (int i=1; true; i++) {
          buf.put(i);
          Util.pause(10, 100);
    } } }

    class Consumer extends Thread {
      public void run() {
        for (;;) 
          System.out.println("Consumed " + buf.get());

    } }

    new Producer().start(); 
    new Consumer().start(); new Consumer().start();
} }

// Pseudo-random numbers and sleeping threads

class Util {
  public static void pause(int length) 
  { try { Thread.sleep(length); } catch (InterruptedException x) {} }

  public static void pause(int a, int b) { pause(random(a, b)); }

  public static int random(int a, int b) 
  { return (int)(a + (b-a+1) * Math.random()); }
}


