// Example 79 from page 61 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.awt.*;

class AnimatedCanvas extends Canvas implements Runnable {
  private int scale = 50, step = 5;

  AnimatedCanvas() { Thread u = new Thread(this); u.start(); }

  public void run() {                           // from Runnable
    for (;;) { // forever sleep and repaint
      try { Thread.sleep(100); } catch (InterruptedException e) { }
      if (scale <= 0 || scale >= 100) 
        step = -step;
      scale += step;
      repaint();
    }
  }

  public void paint(Graphics g) {               // from Canvas
    Dimension size = getSize();
    g.fillRect(scale*(size.width-20)/100,                    0, 20, 20);
    g.fillRect((100-scale)*(size.width-20)/100, size.height-20, 20, 20);
  }

  public Dimension getPreferredSize() { return new Dimension(400, 100); }
  public Dimension getMinimumSize() { return getPreferredSize(); }
}

class Example79 {
  public static void main(String[] args) {
    Canvas anim1 = new AnimatedCanvas();
    Canvas anim2 = new AnimatedCanvas();
    Frame f = new Frame("Animation with threads");
    f.add(anim1, "North"); f.add(anim2, "South"); f.pack(); f.show();
  }
}

