// Example 86 from page 67 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.util.Random;

class Example86 {
  public static void main(String[] args) {
    if (args.length != 1) 
      System.out.println("Usage: java Example86 <length>\n");
    else {
      System.out.println("Timing character replacement, abusing a string buffer:");
      Random rnd = new Random();
      int length = Integer.parseInt(args[0]);
      char[] cbuf = new char[length];
      for (int i=0; i<length; i++) 
        cbuf[i] = (char)(65 + rnd.nextInt(26));
      String s = new String(cbuf);
      for (int i=0; i<10; i++) {
        StringBuffer sb = new StringBuffer(s);
        Timer t = new Timer();
        replaceCharString(sb, 'A', "HA");
        System.out.print(t.check() + " ");
      }
      System.out.println();
    } 
  }

  // In-place replacement in a StringBuffer; very inefficient and strange

  static void replaceCharString(StringBuffer sb, char c1, String s2) {
    int i = 0;                                  // Inefficient
    while (i < sb.length()) {                   // Inefficient
      if (sb.charAt(i) == c1) {                 // Inefficient
        sb.replace(i, i+1, s2);                 // Inefficient
        i += s2.length();                       // Inefficient
      } else                                    // Inefficient
        i += 1;                                 // Inefficient
    }                                           // Inefficient
  }

  private final static class Timer {
    private long starttime;
    
    public Timer() { starttime = System.currentTimeMillis(); }
    
    double check() {
      return (System.currentTimeMillis()-starttime)/1000.0;
    }
  }
}

