// Example 90 from page 75 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.util.*;
import java.sql.*;

class Example90 {
  public static void main(String[] args) throws SQLException { 
    String url = "jdbc:postgresql://localhost/messages";
    String usr = "nobody";
    String pwd = "";

    System.out.println("To run this example you need a data base server, a");
    System.out.println("database, and a suitable JDBC driver.");
    
    try { Class.forName("postgresql.Driver"); } 
    catch (ClassNotFoundException e) 
      { System.out.println("Cannot find the Postgresql driver"); }
    
    Connection conn = DriverManager.getConnection(url, usr, pwd); 
    printNameAndMsg(getRows(conn, "select * from message"));
  }

  // Return the query result as an ArrayList of Map from String to Object
  static ArrayList getRows(Connection conn, String query) 
    throws SQLException {
    Statement stmt = conn.createStatement();
    ResultSet rset = stmt.executeQuery(query); 
    ResultSetMetaData rsmd = rset.getMetaData();
    int columncount = rsmd.getColumnCount();
    ArrayList queryResult = new ArrayList();  // List of Map from String to Object
    while (rset.next()) {
      Map row = new HashMap();
      for (int i=1; i<=columncount; i++) 
        row.put(rsmd.getColumnName(i), rset.getObject(i));
      queryResult.add(row);
    }
    return queryResult;
  }

  static void printNameAndMsg(Collection coll) {
    Iterator rows = coll.iterator();
    while (rows.hasNext()) {
      Map row = (Map)rows.next();
      System.out.println(row.get("name") + ": " + row.get("msg"));
    }
  }
}

