// Example 92 from page 77 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.util.*;
import java.io.*;

// A concordance is a TreeMap mapping a word (a String) to a TreeSet
// of linenumbers (Integer objects)

class Example92 {
  public static void main(String[] args) throws IOException {
    if (args.length != 1) 
      System.out.println("Usage: java Example92 <filename>");
    else {
      SortedMap index = buildIndex(args[0]);
      printIndex(index);
    } 
  }

  // Parse alphanumeric words from the given file, and record them in
  // the index.  The resulting index is a SortedMap from String to
  // SortedSet of Integer (linenumbers)

  static SortedMap buildIndex(String filename) throws IOException {
    Reader r = new BufferedReader(new FileReader(filename));
    StreamTokenizer stok = new StreamTokenizer(r);
    stok.quoteChar('"'); stok.ordinaryChars('!', '/');
    stok.nextToken();
    SortedMap index = new TreeMap(); // Map from String to Set of Integer
    //    SortedMap index = new TreeMap(new IgnoreCaseComparator()); // Map from String to Set of Integer
    while (stok.ttype != StreamTokenizer.TT_EOF) {
      if (stok.ttype == StreamTokenizer.TT_WORD) {
        SortedSet ts;
        if (index.containsKey(stok.sval))       // If word has a set, get it
          ts = (SortedSet)index.get(stok.sval);
        else {
          ts = new TreeSet();                   // Otherwise create one
          index.put(stok.sval, ts);
        }
        ts.add(new Integer(stok.lineno()));
      }
      stok.nextToken();                              
    }
    return index;
  }

  // Print the concordance index by iterating over its entries, and
  // for each entry, iterate over the value which is a set.

  // index is a SortedMap from String to SortedSet of Integer

  static void printIndex(SortedMap index) {
    Iterator wordIter = index.entrySet().iterator();
    while (wordIter.hasNext()) {
      Map.Entry entry = (Map.Entry)wordIter.next();
      System.out.print((String)entry.getKey() + ": ");
      SortedSet lineNoSet = (SortedSet)entry.getValue();
      Iterator lineNoIter = lineNoSet.iterator();
      while (lineNoIter.hasNext()) 
        System.out.print((Integer)lineNoIter.next() + " ");
      System.out.println();
    }
  }
}

