// Example 93 from page 77 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.util.*;

class Time implements Comparable {
  private int hh, mm;           // 24-hour clock
  
  public Time(int hh, int mm) { this.hh = hh; this.mm = mm; }

  // Return neg if this before o; return pos if this after o; return zero if same
  public int compareTo(Object o) {
    Time t = (Time)o;
    return hh != t.hh ? hh - t.hh : mm - t.mm;
  }

  public boolean equals(Object o) {
    Time t = (Time)o;
    return hh == t.hh && mm == t.mm;
  }

  public int hashCode() { return 60 * hh + mm; }

  public String toString() 
  { return (hh < 10 ? "0"+hh : ""+hh) + ":" + (mm < 10 ? "0"+mm : ""+mm); }
}

class Example93 {
  public static void main(String[] args) {
    SortedMap datebook = new TreeMap();    // Map from Time to String
    datebook.put(new Time(12, 30), "Lunch");
    datebook.put(new Time(15, 30), "Afternoon coffee break");
    datebook.put(new Time( 9,  0), "Lecture");
    datebook.put(new Time(13, 15), "Board meeting");
    SortedMap pm = datebook.tailMap(new Time(12, 0));
    Iterator iter = pm.entrySet().iterator();
    while (iter.hasNext()) {
      Map.Entry entry = (Map.Entry)iter.next();
      System.out.println((Time)entry.getKey() + " " + (String)entry.getValue());
    }
  }
}

