// Example 97 from page 81 of Java Precisely edition 1 (The MIT Press 2002)
// Author: Peter Sestoft (sestoft@dina.kvl.dk)

import java.util.*;

class Example97 {
  public static void main(String[] args) {
    Set SS = new HashSet();
    SS.add(mkIntegerSet(new int[] { 2, 3 }));
    SS.add(mkIntegerSet(new int[] { 1, 3 }));
    SS.add(mkIntegerSet(new int[] { 1, 2 }));
    System.out.println("SS = " + SS);
    Set TT = intersectionClose(SS);
    System.out.println("TT = " + TT);
  }

  static Set mkIntegerSet(int[] a) {
    TreeSet ts = new TreeSet(); // Set of Integer
    for (int i=0; i<a.length; i++)
      ts.add(new Integer(a[i]));
    return ts;
  }

  // Given a set SS of sets of Integers, compute its intersection
  // closure, that is, the least set TT such that SS is a subset of TT
  // and such that for any two sets t1 and t2 in TT, their
  // intersection is also in TT.  

  // For instance, if SS is {{2,3}, {1,3}, {1,2}}, 
  // then TT is {{2,3}, {1,3}, {1,2}, {3}, {2}, {1}, {}}.

  // Both the argument and the result is a Set of Set of Object.

  static Set intersectionClose(Set SS) {
    LinkedList worklist = new LinkedList(SS);
    Set TT = new HashSet();
    while (!worklist.isEmpty()) {
      Set S = (Set)worklist.removeLast();
      Iterator TTIter = TT.iterator();
      while (TTIter.hasNext()) {
        Set TS = new TreeSet((Set)TTIter.next());
        TS.retainAll(S);        // Intersection of T and S
        if (!TT.contains(TS)) 
          worklist.add(TS);
      }
      TT.add(S);
    }
    return TT;
  }
}


